//#pragma LINK_INFO DERIVATIVE "mc9s12p128"

/******************************************************************************
													            Copyright (c) Freescale 2009
File Name    : $RCSfile: main.c,v $

Current Revision :	$Revision: 1.0 $

PURPOSE: main program entry.                       
                                                                          
                                                                       
DESCRIPTION:  function main() providing initial program entry.
                                                         
                                                                          
UPDATE HISTORY                                                            
REV  AUTHOR    DATE        DESCRIPTION OF CHANGE                          
---  ------    --------    ---------------------                          
1.0  r28318    05/10/09    - initial coding

     *******************************************************************
     * File created by: Freescale East Kilbride MSG Applications Group *
     *******************************************************************

                                                                          
******************************************************************************/
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale*/
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/

/************************* Include Files *************************************/
/*general includes */
#include <hidef.h>  /* also includes boolean definitions in stdtypes.h     */
#include <MC9S12HY64.h>     /* derivative information */
#include "target.h" 
#include "S12HY_peripherals.h" /* includes peripherals definitions and FSL data types */


/************************* typedefs ******************************************/

/************************* #defines ******************************************/

/************************* Constants *****************************************/
#pragma CONST_SEG DEFAULT

#define CONST (BUSCLK_FREQ_KHZ / 6 /* loop cycles */ )

/************************* Global Variables **********************************/
#pragma DATA_SEG DEFAULT

/************************* function prototypes *******************************/
#pragma CODE_SEG DEFAULT
/************************* Functions *****************************************/
#pragma CODE_SEG DEFAULT

/******************************************************************************
Function Name  : main
Engineer       : r28318	
Date           : 09/06/09
Parameters     : NONE
Returns        : NONE
Notes          : main routine called by Startup.c. 
******************************************************************************/


void main(void) {
   byte txbuffer;

      /* initialise the system clock - 32MHz Bus CLK, 8MHz Crystal */
	 CPMUCLKS_PLLSEL = 1; /*select the PLL as the clock source */
	 CPMUOSC = 0xC4;
   while(!CPMUFLG_UPOSC);	/* wait for OSC to stabilise */
   CPMUREFDIV = ((REFCLK_RANGE<<6) | (PLL_DIVIDER-1));       /* Reference Clock / 1 = 4MHz */
   CPMUSYNR = ((VCO_RANGE<<6) | (PLL_MULTIPLIER-1));         /* configure the PLL  x 16 = 64MHz VCO */
   CPMUPOSTDIV = (PLL_POSTDIVIDER-1);      /* Post divider / 1 = 32MHz Bus CLK */
   while(!CPMUFLG_LOCK)	/* wait for PLL to lock */
   {
   }
	 
  	   /* initialise the IO */   
   PTR = 0x0F;  /* Initialise PR[3:0] High; turn off LEDs */
   DDRR = 0x0F; /* PR[3:0] = output; enable LEDs */

   ATDDIENL = 0xF0; /* enable digital inputs on Switches */  
   PER1AD = 0xF0;   /* Enable pullups on Switches  */
	 
      /* initialise the CAN */  
   CANCTL0 = 0x01;              /*	enter init mode */
   while(!(CANCTL1_INITAK));		/* wait for init mode */

   CANCTL1 = 0xA0;	/* enable CAN module, Loopback Mode, Ext OSC */
   CANBTR0 = 0xC3;	/* sync jump - 4 Tq clocks, prescalar = 3 */
   CANBTR1 = 0x3A;	/* Tseg = 3, Tseg1 = 10, 1 sample per bit */
   CANIDAC = 0x10;	/* four 16-bit filters */

   CANIDAR0 = 0x20;	/* Filter 0, ID=0x100 Standard Identifier */
   CANIDMR0 = 0x00;
   CANIDAR1 = 0x00;
   CANIDMR1 = 0x07; /* AM[2:0] = 7 to receive standard identifiers */

   CANIDAR2 = 0x00; /* Filter 1, ID=0x0000 */
   CANIDMR2 = 0x00;
   CANIDAR3 = 0x00;
   CANIDMR3 = 0x07; /* AM[2:0] = 7 to receive standard identifiers */

   CANIDAR4 = 0x00;	/* Filter 2, ID=0x0000 */
   CANIDMR4 = 0x00;
   CANIDAR5 = 0x00;
   CANIDMR5 = 0x07; /* AM[2:0] = 7 to receive standard identifiers */

   CANIDAR6 = 0x00;	/* Filter 3, ID=0x0000 */
   CANIDMR6 = 0x00;
   CANIDAR7 = 0x00;
   CANIDMR7 = 0x07; /* AM[2:0] = 7 to receive standard identifiers */

   CANCTL0 = 0x00;	/* exit init mode */
   while(CANCTL1_INITAK);			/* wait until module exits init mode */
     
   while(!(CANCTL0_SYNCH));		/* wait for CAN module to synch */
  
	 CANRFLG = 0xC3;					/* reset Rx flags */

  		   
   for(;;)
    {
     while (!CANTFLG);      /* Wait for empty Tx Buffer */
     CANTBSEL = CANTFLG;	 /* Select the empty Tx Buffer */
	   txbuffer = CANTBSEL;  /* Save the empty buffer */

     CANTXIDR0 = 0x20;    /* load message id value to ID regs */
     CANTXIDR1 = 0x00;
     CANTXIDR2 = 0x00;
     CANTXIDR3 = 0x00;

     CANTXDSR0 = (PT1AD);		/* load data to send */

     CANTXDLR = 0x01;			/* set data length */
     CANTXTBPR = 0x80;		/* set data buffer priority */

     CANTFLG = txbuffer;  /* start transmission */

     while(!(CANTFLG & txbuffer));	/* wait for Tx to complete */
     
		 if(CANRFLG_RXF)    /* has a message been received ? */
		  {
		    PTR = (CANRXDSR0>>4); /* Map received switche information to LEDs and display */
        CANRFLG_RXF = 1;    /* Clear RXF */
		  }

		}

}
